package nemosofts.voxradio.adapter.Home;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.nemosofts.view.RoundedImageView;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.List;

import es.claucookie.miniequalizerlibrary.EqualizerView;
import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.item.ItemRadio;

public class AdapterHomeRecent extends RecyclerView.Adapter<AdapterHomeRecent.MyViewHolder> {

    Context context;
    List<ItemRadio> arrayList;

    static class MyViewHolder extends RecyclerView.ViewHolder {

        private final TextView tv_recent_title;
        private final ImageView iv_play_view;
        private final EqualizerView equalizer_recent;
        private final RoundedImageView iv_recently;

        MyViewHolder(View view) {
            super(view);
            tv_recent_title = view.findViewById(R.id.tv_recent_title);
            iv_play_view = view.findViewById(R.id.iv_play_view);
            equalizer_recent = view.findViewById(R.id.equalizer_recent);
            iv_recently = view.findViewById(R.id.iv_recently);
        }
    }

    public AdapterHomeRecent(Context context, List<ItemRadio> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_recently, parent, false);
        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {

        holder.tv_recent_title.setText(arrayList.get(position).getRadioTitle());

        Picasso.get()
                .load(arrayList.get(position).getImage())
                .resize(300,300)
                .placeholder(R.drawable.material_design_default)
                .into(holder.iv_recently);
        
        if (PlayerService.getIsPlayling() && Callback.arrayList_play.get(Callback.playPos).getId().equals(arrayList.get(position).getId()) && Boolean.TRUE.equals(Callback.isRadio)) {
            holder.equalizer_recent.setVisibility(View.VISIBLE);
            holder.equalizer_recent.animateBars();
            holder.iv_play_view.setImageResource(R.drawable.ic_pause);
        } else {
            holder.equalizer_recent.setVisibility(View.GONE);
            holder.equalizer_recent.stopBars();
            holder.iv_play_view.setImageResource(R.drawable.ic_play);
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

}